<?php
///////////////////////////////////////////////////////////////////////////

#require_once 'lib/abstract_preloaded_regular_screen.php';

///////////////////////////////////////////////////////////////////////////

class MyPlugINTvChannelListScreen extends TvChannelListScreen
    implements UserInputHandler
{
    const ID = 'tv_channel_list';

    public static function get_media_url_str($group_id)
    {
        return MediaURL::encode(
            array
            (
                'screen_id' => self::ID,
                'group_id'  => $group_id,
            ));
    }

    ///////////////////////////////////////////////////////////////////////

    protected $tv;
    private $session;
    ///////////////////////////////////////////////////////////////////////

    public function __construct(Tv $tv, $folder_views,$session)
    {
        parent::__construct($tv, $folder_views);
        $this->tv = $tv;
	$this->session = $session;
        UserInputHandlerRegistry::get_instance()->register_handler($this);
    }

    ///////////////////////////////////////////////////////////////////////

    public function get_action_map(MediaURL $media_url, &$plugin_cookies)
    {
        $actions = array();
        #$actions[GUI_EVENT_KEY_ENTER] = ActionFactory::tv_play();
        #$actions[GUI_EVENT_KEY_PLAY] = ActionFactory::tv_play();
        $open_folder_action = UserInputHandlerRegistry::create_action(
                $this, 'play_stream');
        $actions[GUI_EVENT_KEY_ENTER] = $open_folder_action;
	$actions[GUI_EVENT_KEY_PLAY] = $open_folder_action;
	#$actions[GUI_EVENT_KEY_INFO] = ActionFactory::open_folder(TvFavoritesScreen::get_media_url_str(),'Фавориты тв');
        /*$move_backward_favorite_action =
            UserInputHandlerRegistry::create_action(
                $this, 'move_backward');
        $move_backward_favorite_action['caption'] = 'Назад';

        $move_forward_favorite_action =
            UserInputHandlerRegistry::create_action(
                $this, 'move_forward');
        $move_forward_favorite_action['caption'] = 'Вперед';*/

        if ($this->tv->is_favorites_supported())
        {
            $add_favorite_action =
                UserInputHandlerRegistry::create_action(
                    $this, 'add_favorite');
            $add_favorite_action['caption'] = 'Favorite';

            /*$popup_menu_action =
                UserInputHandlerRegistry::create_action(
                    $this, 'popup_menu');*/

            $actions[GUI_EVENT_KEY_D_BLUE] = $add_favorite_action;
           // $actions[GUI_EVENT_KEY_POPUP_MENU] = $popup_menu_action;
        }

        $actions[GUI_EVENT_KEY_INFO] =
           UserInputHandlerRegistry::create_action(
               $this, 'info');
        //$actions[GUI_EVENT_KEY_B_GREEN] = $move_backward_favorite_action;
        //$actions[GUI_EVENT_KEY_C_YELLOW] = $move_forward_favorite_action;
        return $actions;
    }


    private function get_sel_item_update_action(&$user_input, &$plugin_cookies,$sel_increment=null)
    {
        $parent_media_url = MediaURL::decode($user_input->parent_media_url);
        $sel_ndx = $user_input->sel_ndx;
        if ($sel_ndx < 0)
            $sel_ndx = 0;
        $group = $this->tv->get_group($parent_media_url->group_id);
        $channels = $group->get_channels($plugin_cookies);

        $items[] = $this->get_regular_folder_item($group,
            $channels->get_by_ndx($sel_ndx), $plugin_cookies);
        $range = HD::create_regular_folder_range($items,
            $sel_ndx, $channels->size());

        return ActionFactory::update_regular_folder($range, false);
    }
    public function handle_user_input(&$user_input, &$plugin_cookies)
    {
        hd_print('Tv favorites: handle_user_input:');
        foreach ($user_input as $key => $value)
            hd_print("  $key => $value");
        if ($user_input->control_id == 'info')
        {
            if (!isset($user_input->selected_media_url))
                return null;
            $media_url = MediaURL::decode($user_input->selected_media_url);
            $channel_id = $media_url->channel_id;

            $channels = $this->tv->get_channels();
            $c = $channels->get($channel_id);
            $id = $c->get_id();
            $title = $c->get_title();

            return ActionFactory::show_title_dialog("Channel '$title' (id=$id)");
        }
        elseif ($user_input->control_id == 'play_stream')
	{
		#$this->session->isogged_srv();
		hd_print("rrrrrr");
		return ActionFactory::tv_play();
	}
	elseif ($user_input->control_id == 'move_backward')
        {
            if (!isset($user_input->selected_media_url))
                return null;

            $media_url = MediaURL::decode($user_input->selected_media_url);
            $channel_id = $media_url->channel_id;
	    $this->session->set_channels_order($channel_id,'up');
	    $this->tv->unload_channels();
	    $this->tv->newload($plugin_cookies);
	    #$user_input->sel_ndx = $user_input->sel_ndx - 1;
	    $media_url_ = MediaURL::decode($user_input->parent_media_url);
	    $range = HD::create_regular_folder_range(
            	$this->get_all_folder_items($media_url_, &$plugin_cookies));
	    return ActionFactory::update_regular_folder($range, false);
        }
        else if ($user_input->control_id == 'move_forward')
        {
            if (!isset($user_input->selected_media_url))
                return null;

            $media_url = MediaURL::decode($user_input->selected_media_url);
            $channel_id = $media_url->channel_id;


	    $this->session->set_channels_order($channel_id,'down');
	    $this->tv->unload_channels();
	    $this->tv->newload($plugin_cookies);
	    #$user_input->sel_ndx = $user_input->sel_ndx + 1;
	    $media_url_ = MediaURL::decode($user_input->parent_media_url);
	    $range = HD::create_regular_folder_range(
            	$this->get_all_folder_items($media_url_, &$plugin_cookies));
	    return ActionFactory::update_regular_folder($range, false);
        }
        else if ($user_input->control_id == 'popup_menu')
        {
            if (!isset($user_input->selected_media_url))
                return null;

            $media_url = MediaURL::decode($user_input->selected_media_url);
            $channel_id = $media_url->channel_id;

            $is_favorite = $this->tv->is_favorite_channel_id($channel_id, $plugin_cookies);
            $add_action =
                UserInputHandlerRegistry::create_action(
                    $this, 'add_favorite');
            $caption = 'Добавить в Избранное';
	    $menu_items[] = array(
                GuiMenuItemDef::caption => $caption,
                GuiMenuItemDef::action => $add_action);
            $add_action =
                UserInputHandlerRegistry::create_action(
                    $this, 'reset_channels');
            $caption = 'Сброс на дефолтный список каналов';
            $menu_items[] = array(
                GuiMenuItemDef::caption => $caption,
                GuiMenuItemDef::action => $add_action);

            return ActionFactory::show_popup_menu($menu_items);
        }
        else if ($user_input->control_id == 'reset_channels')
        {
		$this->session->set_channels_order(-1,'reset');
	        $this->tv->unload_channels();
	        $this->tv->newload($plugin_cookies);
	    	$media_url_ = MediaURL::decode($user_input->parent_media_url);
	    	$range = HD::create_regular_folder_range(
            		$this->get_all_folder_items($media_url_, &$plugin_cookies));
	    	return ActionFactory::update_regular_folder($range, false);		

	}
        else if ($user_input->control_id == 'add_favorite')
        {
            if (!isset($user_input->selected_media_url))
                return null;

            $media_url = MediaURL::decode($user_input->selected_media_url);
            $channel_id = $media_url->channel_id;

            $is_favorite = $this->tv->is_favorite_channel_id($channel_id, $plugin_cookies);
            if ($is_favorite)
            {
                return ActionFactory::show_title_dialog(
                    'Канал уже находится в Избранном',
                    $this->get_sel_item_update_action($user_input, $plugin_cookies));
            }
            else
            {
                $this->tv->change_tv_favorites(PLUGIN_FAVORITES_OP_ADD,
                    $channel_id, $plugin_cookies);

                return ActionFactory::show_title_dialog(
                    'Канал успешно добавлен в Избранное',
                    $this->get_sel_item_update_action(
                        $user_input, $plugin_cookies));
            }
        }
        return null;
    }

    ///////////////////////////////////////////////////////////////////////

    private function get_regular_folder_item($group, $c, &$plugin_cookies)
    {
        return array
        (
            PluginRegularFolderItem::media_url =>
                MediaURL::encode(
                    array(
                        'channel_id' => $c->get_id(),
                        'group_id' => $group->get_id())),
            PluginRegularFolderItem::caption => $c->get_title(),
            PluginRegularFolderItem::view_item_params => array
            (
                ViewItemParams::icon_path => $c->get_icon_url(),
                ViewItemParams::item_detailed_icon_path => $c->get_icon_url(),
            ),
            PluginRegularFolderItem::starred =>
                $this->tv->is_favorite_channel_id(
                    $c->get_id(), $plugin_cookies),
        );
    }

    public function get_all_folder_items(MediaURL $media_url, &$plugin_cookies)
    {
        $this->tv->folder_entered($media_url, $plugin_cookies);

        $this->tv->ensure_channels_loaded($plugin_cookies);

        $group = $this->tv->get_group($media_url->group_id);

        $items = array();
        foreach ($group->get_channels($plugin_cookies) as $c)
        {
            $items[] = $this->get_regular_folder_item(
                $group, $c, $plugin_cookies);
        }

        return $items;
    }

    public function get_archive(MediaURL $media_url)
    {
        return $this->session->get_archive();
    }
}

///////////////////////////////////////////////////////////////////////////
?>
