<?php
///////////////////////////////////////////////////////////////////////////

require_once 'lib/default_dune_plugin.php';
require_once 'lib/utils.php';
require_once 'lib/default_archive.php';


require_once 'lib/tv/tv_group_list_screen.php';
require_once 'lib/tv/tv_channel_list_screen.php';
require_once 'lib/tv/tv_favorites_screen.php';

require_once 'lib/vod/vod_list_screen.php';
require_once 'lib/vod/vod_search_screen.php';
require_once 'lib/vod/vod_genres_screen.php';
require_once 'lib/vod/vod_movie_screen.php';
require_once 'lib/vod/vod_series_list_screen.php';
require_once 'lib/vod/vod_favorites_screen.php';

require_once 'tv_config.php';
require_once 'tv_api.php';
require_once 'ozo_tv.php';
require_once 'tv_setup_screen.php';
require_once 'tv_exception.php';
require_once 'tv_tv.php';
require_once 'tv_entry_handler.php';
require_once 'tv_main_category_list_screen.php';
require_once 'tv_tv_group_list_screen.php';
require_once 'tv_channel_list_screen.php';

require_once 'tv_vod_category_list_screen.php';
require_once 'tv_vod.php';
require_once 'tv_vod_list_screen.php';
require_once 'tv_vod_genres_screen.php';

///////////////////////////////////////////////////////////////////////////

class MyPlugIN_Plugin extends DefaultDunePlugin
{
    private $session;
    public function __construct()
    {
	$this->session = new MyPlugIN_Api();
        $this->tv = new MyPlugINTv($this->session);
	$this->add_screen(new MyPlugIN_MainCategoryListScreen($this->session,$this->tv));
        $this->vod = new MyPlugIN_Vod($this->session);
        $tv_folder_views = $this->get_tv_folder_views();
	$this->entry_handler = new MyPlugIN_EntryHandler($this->session,$this->tv);
        $this->add_screen(new MyPlugIN_SetupScreen($this->session,$this->tv));

        $this->add_screen(new MyPlugIN_TvGroupListScreen($this->tv,
                MyPlugIN_Config::GET_TV_GROUP_LIST_FOLDER_VIEWS()));
        $this->add_screen(new MyPlugINTvChannelListScreen($this->tv,
                MyPlugIN_Config::GET_TV_CHANNEL_LIST_FOLDER_VIEWS(),$this->session));
        $this->add_screen(new TvFavoritesScreen($this->tv,
                MyPlugIN_Config::GET_TV_CHANNEL_LIST_FOLDER_VIEWS()));


        $this->add_screen(new MyPlugIN_VodCategoryListScreen($this->session));
  
	$this->add_screen(new MyPlugIN_VodListScreen($this->session,$this->vod));

        $this->add_screen(new VodMovieScreen($this->vod));

        $this->add_screen(new VodSeriesListScreen($this->vod));

        $this->add_screen(new VodFavoritesScreen($this->vod));

        $this->add_screen(new VodSearchScreen($this->vod));

        $this->add_screen(new MyPlugIN_VodGenresScreen($this->vod));
	
    }

    ///////////////////////////////////////////////////////////////////////

    private function get_tv_folder_views()
    {
	$more = file_get_contents(dirname(__FILE__).'/dune_plugin.xml');
	$more = simplexml_load_string($more);
	if($more->name != base64_decode('T1pPLnR2'))
		throw new Exception('Invalid XML document');
        return MyPlugIN_Config::GET_TV_CHANNEL_LIST_FOLDER_VIEWS();
    }
}

///////////////////////////////////////////////////////////////////////////
?>
