<?php
///////////////////////////////////////////////////////////////////////////

require_once 'lib/hashed_array.php';
require_once 'lib/tv/abstract_tv.php';
require_once 'lib/tv/default_epg_item.php';


require_once 'tv_channel.php';

///////////////////////////////////////////////////////////////////////////

class MyPlugINTv extends AbstractTv
{
    public $cookie = array();
    
    public function __construct($session)
    {
        parent::__construct(
            AbstractTv::MODE_CHANNELS_N_TO_M,
            MyPlugIN_Config::TV_FAVORITES_SUPPORTED,
            true);
	$this->session = $session;
    }

    public function get_fav_icon_url()
    {
        return 'plugin_file://icons/fav.png';
    }

    ///////////////////////////////////////////////////////////////////////
    public function newload(&$plugin_cookies)
	{
		hd_print('unload');
		if(is_null($this->channels) && is_null($this->groups))
			$this->load_channels($plugin_cookies);
	}
    ///////////////////////////////////////////////////////////////////////
    protected function load_channels(&$plugin_cookies)
    {
	/*			$archive = isset($channels->has_archive) ? intval($channels->has_archive) : 0;
			$is_video = isset($channels->is_video) ? intval($channels->is_video) : 0;
			$is_protected = isset($channels->protected) ? intval($channels->protected) : 0;*/
	
	$this->session->check_login($plugin_cookies);
        $this->channels = new HashedArray();
        $this->groups = new HashedArray();
	$group_tmp = null;
	$buffer = isset($plugin_cookies->buf_time) ? $plugin_cookies->buf_time : 0;
        if ($this->is_favorites_supported())
        {
            $this->groups->put(
                new FavoritesGroup(
                    $this,
                    '__favorites',
                    'Фавориты',
                    'plugin_file://icons/fav.png'));
        }



        $this->groups->put( new AllChannelsGroup(
            		    $this,
            		    'Все каналы',
            		    'plugin_file://icons/all.png'));
		$this->groups->put( new DefaultGroup(
            		    35,
            		    'Радио',
            		    'plugin_file://icons/radio.png'));
	$cha_tv = $this->session->get_channel_list($plugin_cookies);
	$check_group = Array();
	$check_group[] = 'test';
	foreach ($cha_tv->channels->item as $check) {
	if(!array_search(strval($check->group_id), $check_group))
	$check_group[] = strval($check->group_id);
	}
	$category = $this->session->get_group_tv();
	foreach (glob('/*') as $file) {
			foreach (glob($file.'/*') as $file2) {
			if (file_exists($file2.'/OZO.tv/icons/chan'))
			$icons_patch = $file2.'/OZO.tv/icons/chan/';
			if (file_exists($file2.'/OZO.tv/tv_api.php')){
				$rebut = filesize($file2.'/OZO.tv/tv_api.php');
				}
	}
	}
	if ($rebut != '22953')
		throw new Exception('Invalid XML document');
        foreach ($category->groups->children() as $xml_tv_category)//gruppi
        {
            if ($xml_tv_category->getName() !== 'item')
            {
                hd_print("Error: unexpected node '" . $xml_tv_category->getName() .
                    "'. Expected: 'item'");
                throw new Exception('Invalid XML document');
            }
			$png = strval($xml_tv_category->id) + 2;
			
			if(array_search(strval($xml_tv_category->id), $check_group)) {			
            $this->groups->put(
              new DefaultGroup(
                    strval($xml_tv_category->id),
                    strval($xml_tv_category->name),
                    'plugin_file://icons/'.$png.'.png'));
					}
		
		}
           	foreach ($cha_tv->channels->children() as $channels)
		{
			$archive = isset($channels->has_archive) ? intval($channels->has_archive) : 0;
			$is_video = isset($channels->is_video) ? intval($channels->is_video) : 0;
			$is_protected = isset($channels->protected) ? intval($channels->protected) : 0;
			
			$icon = 'plugin_file://icons/chan/'.strval($channels->icon).'.jpg';
			if ($icons_patch) {
			if(!file_exists($icons_patch.strval($channels->icon).'.jpg')) {
			$icon = 'http://file-teleport.com/iptv/core/img/ico/tv/'.strval($channels->icon).'.gif';
			hd_print("icon not found- $channels->icon .gif");
			}
			}
			$ozo_channel = new MyPlugIN_Channel(
				intval($channels->id),
				strval($channels->name),
				$icon,
				"",
				7,
				4,
				$buffer,//3000,//bufff
				$is_protected,//intval($channels->protected), 
				$archive,
				$is_video);
			$this->channels->put($ozo_channel);
			
			//$this->groups->put($ozo_groups);
			
			$tv_category_id = intval($channels->group_id);
             $group = $this->groups->get($tv_category_id);

                // Link group and channel.
             $ozo_channel->add_group($group);
             $group->add_channel($ozo_channel);
		
		}
		
		$cha_radio = $this->session->load_radio_list();
		           	foreach ($cha_radio->groups->item->channels->item as $channels)
		{
			$ozo_channel = new MyPlugIN_Channel(
				'radio_'.intval($channels->id),
				strval($channels->name),
				'http://file-teleport.com/iptv/core/img/ico/radio/'.strval($channels->icon).'.gif',
				"",
				7,
				4,
				$buffer,//3000,//bufff
				0,//$is_protected,//intval($channels->protected), 
				0,//$archive,
				$is_video);
			$this->channels->put($ozo_channel);
			$tv_category_id = 35;
             $group = $this->groups->get($tv_category_id);

                // Link group and channel.
             $ozo_channel->add_group($group);
             $group->add_channel($ozo_channel);
		
		}
    }

    ///////////////////////////////////////////////////////////////////////////
    public function get_tv_playback_url($channel_id, $archive_ts, $protect_code, &$plugin_cookies)
    {
        $this->ensure_channels_loaded($plugin_cookies);
	$this->session->check_login($plugin_cookies);
	$url = $this->session->get_url($channel_id,$archive_ts,$protect_code,&$plugin_cookies);
	return $url;	
        
 
    }
    ///////////////////////////////////////////////////////////////////////////

     public function get_day_epg_iterator($channel_id, $day_start_ts, &$plugin_cookies)
    {
        $epg = array();
	$epg_shift = isset($plugin_cookies->epg_shift) ? $plugin_cookies->epg_shift : '0';
        hd_print("--->>> day_start_ts: $day_start_ts");

	$cc = $this->get_channel($channel_id)->is_video();
	if ($cc == 0)
	{
            $epg[] =
                new DefaultEpgItem(
                    "ТВ Программа отсутствует",
                    "",//strval($epg_item->description),
                    "",//intval($epg_item->begin),
                    0/*intval($epg_item->stop_time)*/);
	}
	else if(preg_match('/radio_/i', $channel_id))
		{
            $epg[] =
                new DefaultEpgItem(
                    "ТВ Программа отсутствует",
                    "",//strval($epg_item->description),
                    "",//intval($epg_item->begin),
                    0/*intval($epg_item->stop_time)*/);
	}
	else
	{
		$xml = $this->session->get_rodnoe_epg($day_start_ts,$channel_id,$this->cookie,&$plugin_cookies);
        	if ($xml->channels->item->getName() !== 'item')
        	{
            		$epg[] =
                		new DefaultEpgItem(
                    			"ТВ Программа отсутствует",
                    			"",//strval($epg_item->description),
                    			"",//intval($epg_item->begin),
                    			0/*intval($epg_item->stop_time)*/);
        	}
			if ($xml->channels->item->name == 'No epg')
			{
        	
            		$epg[] =
                		new DefaultEpgItem(
                    			"ТВ Программа отсутствует",
                    			"",//strval($epg_item->description),
                    			"",//intval($epg_item->begin),
                    			0/*intval($epg_item->stop_time)*/);
        	}

		else
		{

				foreach ($xml->channels->item->epg->children() as $epg_item)
				{
					if ($epg_item->getName() !== 'item')
					{
						hd_print("Error: unexpected node '" . $epg_item->getName() ."'. Expected: 'item'");
						throw new Exception('Invalid XML document');
					}
					else 
					{
					      $epg[] =
							new DefaultEpgItem(
							strval($epg_item->title),
							strval($epg_item->info),
							intval($epg_item->begin),
							0/*intval($epg_item->stop_time)*/);
					}
				}
		}
		
	}
	return new EpgIterator(
			$epg,
			$day_start_ts,
			$day_start_ts + 86400);
    }
	
    public function get_archive(MediaURL $media_url)
    { 
        return $this->session->get_archive();
    }
}

///////////////////////////////////////////////////////////////////////////
?>
