<?php
///////////////////////////////////////////////////////////////////////////

require_once 'lib/tv/tv_group_list_screen.php';

///////////////////////////////////////////////////////////////////////////

class MyPlugIN_TvGroupListScreen extends TvGroupListScreen
{
    const ID = 'tv_group_list';

    ///////////////////////////////////////////////////////////////////////
    public static function get_media_url_str()
    {
        return MediaURL::encode(
            array
            (
                'screen_id' => self::ID,
            ));
    }
    ///////////////////////////////////////////////////////////////////////

    public function get_all_folder_items(MediaURL $media_url, &$plugin_cookies)
    {
        $this->tv->folder_entered($media_url, $plugin_cookies);

        $this->tv->ensure_channels_loaded($plugin_cookies);

        $items = array();

        foreach ($this->tv->get_groups() as $group)
        {
            $media_url = $group->is_favorite_channels() ?
                TvFavoritesScreen::get_media_url_str() :
                MyPlugINTvChannelListScreen::get_media_url_str($group->get_id());
	    #$iconsel = str_ireplace(".png","_sel.png",$group->get_icon_url());
		$test = json_decode(MyPlugINTvChannelListScreen::get_media_url_str($group->get_id()));
	    if ($test->group_id != 35) {
            $items[] = array
            (
                PluginRegularFolderItem::media_url => $media_url,
                PluginRegularFolderItem::caption => $group->get_title(),
                PluginRegularFolderItem::view_item_params => array
                (
                    ViewItemParams::icon_path => $group->get_icon_url(),
		    #ViewItemParams::icon_sel_path => $iconsel,
                    ViewItemParams::item_detailed_icon_path => $group->get_icon_url()
                )
            );
			}
        }

        $this->tv->add_special_groups($items);

        return $items;
    }

   # public function get_archive(MediaURL $media_url)
   # { 
   #     return $this->session->get_archive();
   # }
}

///////////////////////////////////////////////////////////////////////////
?>
