<?php
///////////////////////////////////////////////////////////////////////////

require_once 'lib/vod/abstract_vod.php';
require_once 'lib/vod/movie.php';

///////////////////////////////////////////////////////////////////////////

class MyPlugIN_Vod extends AbstractVod
{
    private $session;
    public function __construct($session)
    {
        parent::__construct(
            MyPlugIN_Config::VOD_FAVORITES_SUPPORTED,
            MyPlugIN_Config::VOD_MOVIE_PAGE_SUPPORTED,
            true);
	$this->session = $session;
    }

    ///////////////////////////////////////////////////////////////////////

    public function try_load_movie($movie_id, &$plugin_cookies)
    {
	$this->session->check_login($plugin_cookies);
	$data = $this->session->get_vod_info($movie_id);
        $movie = new Movie(intval($data->groups->item->id));
        $movie->set_data(
            strval($data->groups->item->title),
            ''.$data->film->viewed,//name_orig
            strip_tags($data->groups->item->description),
            strval($data->groups->item->pic),
            $data->groups->item->lenght,
            $data->groups->item->year,
            $data->groups->item->director,
            '',//writer
            $data->groups->item->actors,
            $data->groups->item->genre_str,
            '',//imdb
            '',//kinopoisk
            '',//mpaa
            $data->groups->item->country,
            $data->groups->item->budget);

        foreach ($data->groups->item as $item)
        {
	 $url = $this->session->get_vod_url($item->id);
	 $url = $url->url;
	 //$url = str_ireplace("http://","http://mp4://",$url);
	 hd_print("url_vod:$url");
         $movie->add_series_data(
                $item->id,
                $item->format,
                $url,
                true);
        }
        $this->set_cached_movie($movie);
    }
    public function get_vod_stream_url($playback_url, &$plugin_cookies)
    {
	 hd_print("playback_url:$playback_url");
	 $url = $this->session->get_vod_url($playback_url);
	 $url_ = explode(" :", $url);
	 hd_print("url_vod:$url");
	 hd_print("url_vod:$url_[0]");
        #return $this->session->vod_get_url($playback_url);
        $url = str_ireplace("http://","http://mp4://",$playback_url);
        return $url;
    }



    public function get_vod_info(MediaURL $media_url, &$plugin_cookies)
    {

       	$movie = $this->get_loaded_movie($media_url->movie_id,$plugin_cookies);
	if ($movie === null)
        {
    	    return null;
        }
        $sel_id = isset($media_url->series_id) ? $media_url->series_id : null;
        $buff = 3000;//$plugin_cookies->buf_time;
        hd_print("buffer:$buff");
        return $movie->get_vod_info($sel_id,$buff);
    }

    ///////////////////////////////////////////////////////////////////////
    // Genres.


    protected function load_genres(&$plugin_cookies)
    {
	$this->session->check_login($plugin_cookies);
        $data = $this->session->get_vod_genres();

        $genres = array();
        foreach ($data->groups->item as $genre)
	{
            $genres[intval($genre->id)] = strval($genre->title);
	    //hd_print("dddd-----:$genre->id - $genre->title - $genre->id .png");
	}
        return $genres;
    }

    public function get_genre_icon_url($genre_id)
    {
	$genre_id = $genre_id + 13;
	if ($genre_id == 39)
		$genre_id = 38;
	#$genre_icon = $genre_id.'_vod.png';
	#$genre_icon = 'vod_icon.png';
	hd_print("ico:$genre_id");
        return 'plugin_file://icons/vod/'.$genre_id.'.png';
    }

    public function get_genre_media_url_str($genre_id)
    {
        return MyPlugIN_VodListScreen::get_media_url_str('genres', $genre_id);
    }

  public function get_vod_genres_folder_views()
    {
        #$mov_genre_default_icon_url = Newrus_Config::VOD_GROUP_ICON_PATH.'genre_vod.png';

        return MyPlugIN_Config::GET_VOD_CAT_LIST_FOLDER_VIEWS();
    }
    ///////////////////////////////////////////////////////////////////////
    // Favorites.

    protected function load_favorites(&$plugin_cookies)
    {
        $fav_movie_ids = $this->get_fav_movie_ids_from_cookies($plugin_cookies);

        foreach ($fav_movie_ids as $movie_id)
        {
            if ($this->has_cached_short_movie($movie_id))
                continue;

            $this->ensure_movie_loaded($movie_id, $plugin_cookies);
        }

        $this->set_fav_movie_ids($fav_movie_ids);

        hd_print('The ' . count($fav_movie_ids) . ' favorite movies loaded.');
    }

    protected function do_save_favorite_movies(&$fav_movie_ids, &$plugin_cookies)
    {
        $this->set_fav_movie_ids_to_cookies($plugin_cookies, $fav_movie_ids);
    }

    ///////////////////////////////////////////////////////////////////////

    public function get_fav_movie_ids_from_cookies(&$plugin_cookies)
    {
        if (!isset($plugin_cookies->{'favorite_movies'}))
            return array();

        $arr = preg_split('/,/', $plugin_cookies->{'favorite_movies'});

        $ids = array();
        foreach ($arr as $id)
        {
            if (preg_match('/\S/', $id))
                $ids[] = $id;
        }
        return $ids;
    }

    public function set_fav_movie_ids_to_cookies(&$plugin_cookies, &$ids)
    {
        $plugin_cookies->{'favorite_movies'} = join(',', $ids);
    }

    ///////////////////////////////////////////////////////////////////////

    ///////////////////////////////////////////////////////////////////////
    // Search.


    public function get_search_media_url_str($pattern)
    {
        return MyPlugIN_VodListScreen::get_media_url_str('search', $pattern);
    }


    ///////////////////////////////////////////////////////////////////////
    // Folder views.

    public function get_vod_list_folder_views()
    {
        return MyPlugIN_Config::GET_VOD_MOVIE_LIST_FOLDER_VIEWS();
    }

    public function get_archive(MediaURL $media_url)
    { 
        return $this->session->get_archive();
    }
}

///////////////////////////////////////////////////////////////////////////
?>
