<?php
///////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////

class MyPlugIN_VodCategoryListScreen extends AbstractPreloadedRegularScreen
{
    const ID = 'vod_category_list';
    
    public static function get_media_url_str()
    {
        return MediaURL::encode(
            array
            (
                'screen_id'     => self::ID,
            ));
    }

    //////////////////////////////////////////////////////////////////////
    private $session;
    ///////////////////////////////////////////////////////////////////////

    public function __construct($session)
    {
        parent::__construct(
            self::ID, $this->get_folder_views());
	$this->session = $session;
    }

    ///////////////////////////////////////////////////////////////////////

    public function get_action_map(MediaURL $media_url, &$plugin_cookies)
    {
        return array(
            GUI_EVENT_KEY_ENTER => ActionFactory::open_folder(),
        );
    }

    ///////////////////////////////////////////////////////////////////////

    public function get_all_folder_items(MediaURL $media_url, &$plugin_cookies)
    {

	$this->session->check_login($plugin_cookies);
        if (MyPlugIN_Config::VOD_FAVORITES_SUPPORTED)
        {
    	    $icon_fav = 'plugin_file://icons/vod/vod_fav.png';
    	    #$iconsel = 'plugin_file://icons/vod_groups/fav_vod_sel.png';
            $items[] = array
            (
                PluginRegularFolderItem::media_url => VodFavoritesScreen::get_media_url_str(),
                PluginRegularFolderItem::caption => 'Избранное',
                PluginRegularFolderItem::view_item_params => array
                (
                    ViewItemParams::icon_path => $icon_fav,
                    ViewItemParams::item_detailed_icon_path =>  $icon_fav,
		    #ViewItemParams::icon_sel_path => $this->session->get_icon('fav_vod_sel.png'),		    
                )
            );
        }
    	$icon_search = 'plugin_file://icons/vod/vod_search.png';
    	#$iconsel = Newrus_Config::VOD_GROUP_ICON_PATH.'search_vod_sel.png';
        $items[] = array
            (
                PluginRegularFolderItem::media_url => VodSearchScreen::get_media_url_str(),
                PluginRegularFolderItem::caption => 'Поиск' ,
                PluginRegularFolderItem::view_item_params => array
                (
                    ViewItemParams::icon_path => $icon_search,
                    ViewItemParams::item_detailed_icon_path => $icon_search ,
		    #ViewItemParams::icon_sel_path => $this->session->get_icon('search_vod_sel.png'),
                )
            );

    	$icon_all_film = 'plugin_file://icons/vod/vod_all.png';
    	#$iconsel = Newrus_Config::VOD_GROUP_ICON_PATH.'all_vod_sel.png';
        $items[] = array
            (
                PluginRegularFolderItem::media_url => MyPlugIN_VodListScreen::get_media_url_str('all'),
                PluginRegularFolderItem::caption => 'Все фильмы' ,
                PluginRegularFolderItem::view_item_params => array
                (
                    ViewItemParams::icon_path => $icon_all_film,
                    ViewItemParams::item_detailed_icon_path => $icon_all_film,
		    #ViewItemParams::icon_sel_path => $this->session->get_icon('all_vod_sel.png'),
                )
            );

    	$icon_genres = 'plugin_file://icons/vod/vod_cat.png';
	#$iconsel = Newrus_Config::VOD_GROUP_ICON_PATH.'genres_vod_sel.png';
        $items[] = array
            (
                PluginRegularFolderItem::media_url => MyPlugIN_VodGenresScreen::get_media_url_str(),
                PluginRegularFolderItem::caption => 'Категории' ,
                PluginRegularFolderItem::view_item_params => array
                (
                    ViewItemParams::icon_path => $icon_genres,
                    ViewItemParams::item_detailed_icon_path => $icon_genres,
		    #ViewItemParams::icon_sel_path => $this->session->get_icon('genres_vod_sel.png'),
                )
            );  
 

        return $items;
    }

    ///////////////////////////////////////////////////////////////////////
    public function get_archive(MediaURL $media_url)
    { 
        return $this->session->get_archive();
    }
    ///////////////////////////////////////////////////////////////////////

    private function get_folder_views()
    {
    	return MyPlugIN_Config::GET_VOD_CATEGORY_LIST_FOLDER_VIEWS();
    }
}

///////////////////////////////////////////////////////////////////////////
?>
