<?php
require_once 'lib/vod/vod_genres_screen.php';

class MyPlugIN_VodGenresScreen extends VodGenresScreen
	implements UserInputHandler
{
    public static function get_media_url_str()
    {
        return MediaURL::encode(array('screen_id' => self::ID));
    }
    private $vod;

    public function __construct(Vod $vod)
    {
        $this->vod = $vod;

        parent::__construct($vod);

        UserInputHandlerRegistry::get_instance()->register_handler($this);
    }
    ///////////////////////////////////////////////////////////////////////


    public function get_all_folder_items(MediaURL $media_url, &$plugin_cookies)
    {
        $this->vod->folder_entered($media_url, $plugin_cookies);

        $this->vod->ensure_genres_loaded($plugin_cookies);

        $genre_ids = $this->vod->get_genre_ids();

        $items = array();

        foreach ($genre_ids as $genre_id)
        {
            $caption = $this->vod->get_genre_caption($genre_id);
            $media_url_str = $this->vod->get_genre_media_url_str($genre_id);
            $icon_url = $this->vod->get_genre_icon_url($genre_id);
			hd_print("$icon_url");
	    #$iconsel = str_ireplace(".png","_sel.png",$icon_url);
            $items[] = array
            (
                PluginRegularFolderItem::media_url => $media_url_str,
                PluginRegularFolderItem::caption => $caption,
                PluginRegularFolderItem::view_item_params => array
                (
                    ViewItemParams::icon_path => $icon_url,
		    #ViewItemParams::icon_sel_path => $iconsel,
                )
            );
        }

        return $items;
    }

    #public function get_archive(MediaURL $media_url)
    #{
    #    return $this->session->get_archive();
    #}
}

?>
