<?php
///////////////////////////////////////////////////////////////////////////

require_once 'lib/vod/vod_list_screen.php';

class MyPlugIN_VodListScreen extends VodListScreen
{
    private $session;
    public static function get_media_url_str($cat_id,$text = null)
    {
        $arr['screen_id'] = self::ID;
        $arr['category_id'] = $cat_id;
	if($cat_id === 'search')
		$arr['pattern'] = $text;
        else if ($cat_id === 'genres')
            $arr['genre_id'] = $text;
        return MediaURL::encode($arr);
    }

    ///////////////////////////////////////////////////////////////////////

    public function __construct($session, Vod $vod)
    {
        parent::__construct($vod);
	$this->session = $session;
	$this->vod = $vod;
    }
    public function get_action_map(MediaURL $media_url, &$plugin_cookies)
    {
        $actions = array();

        if ($this->vod->is_movie_page_supported())
            $actions[GUI_EVENT_KEY_ENTER] = ActionFactory::open_folder();
        else
            $actions[GUI_EVENT_KEY_ENTER] = ActionFactory::vod_play();

        if ($this->vod->is_favorites_supported())
        {
            $add_favorite_action =
                UserInputHandlerRegistry::create_action(
                    $this, 'add_favorite');
            $add_favorite_action['caption'] = 'Фавориты';


            $actions[GUI_EVENT_KEY_D_BLUE] = $add_favorite_action;
        }

        return $actions;
    }
    ///////////////////////////////////////////////////////////////////////
    public function handle_user_input(&$user_input, &$plugin_cookies)
    {
        hd_print('Vod favorites: handle_user_input:');
        foreach ($user_input as $key => $value)
            hd_print("  $key => $value");

  	if ($user_input->control_id == 'add_favorite')
        {
            if (!isset($user_input->selected_media_url))
                return null;

            $media_url = MediaURL::decode($user_input->selected_media_url);
            $movie_id = $media_url->movie_id;

            $is_favorite = $this->vod->is_favorite_movie_id($movie_id);
            if ($is_favorite)
            {
                return ActionFactory::show_title_dialog(
                    'Фильм уже в фаворитах');
            }
            else
            {
                $this->vod->add_favorite_movie($movie_id, $plugin_cookies);

                return ActionFactory::show_title_dialog(
                    'Фильм был добавлен в фавориты');
            }
        }

        return null;
    }

    protected function get_short_movie_range(MediaURL $media_url, $from_ndx,
        &$plugin_cookies)
    {
	$this->session->check_login($plugin_cookies);
	if($media_url->category_id === 'search')
	{
	$page = 1;
		$data = $this->session->get_vod_list('search',$media_url->pattern,$page);
		$movies = array();
        foreach ($data->groups->item as $movie)
			{
			$poster = $movie->poster;
            $movies[] = new ShortMovie(
                intval($movie->id),
                strval($movie->title),
                strval($movie->pic));
			}
	}
	elseif($media_url->category_id === 'all')
	{
		$page = 1;
        	$data = $this->session->get_vod_list('all',0,$page);
			$count = ceil($data->options->count / 100);
			hd_print("--count--->$count");
		$movies = array();
        foreach ($data->groups->item as $movie)
			{
			$poster = $movie->poster;
            $movies[] = new ShortMovie(
                intval($movie->id),
                strval($movie->title),
                strval($movie->pic));
			}
			if ($count > 1) {
				for ($i=2; $i<=$count; $i++) {
					$page = $i;
					$data = $this->session->get_vod_list('all',0,$page);
					foreach ($data->groups->item as $movie)
					{
					#$poster = str_ireplace("/vodCoversSmall/","/vodCoversBig/",$movie->poster);
					$poster = $movie->poster;
					$movies[] = new ShortMovie(
					intval($movie->id),
					strval($movie->title),
					strval($movie->pic));
					}
				}
			}
        }
	elseif($media_url->category_id === 'genres')
	{
	$page = 1;
		$data = $this->session->get_vod_list('genres',$media_url->genre_id,$page);
		$count = ceil($data->options->count / 100);
	$movies = array();
        foreach ($data->groups->item as $movie)
			{
			$poster = $movie->poster;
            $movies[] = new ShortMovie(
                intval($movie->id),
                strval($movie->title),
                strval($movie->pic));
			}
			if ($count > 1) {
				for ($i=2; $i<=$count; $i++) {
					$page = $i;
					$data = $this->session->get_vod_list('all',0,$page);
					foreach ($data->groups->item as $movie)
					{
					#$poster = str_ireplace("/vodCoversSmall/","/vodCoversBig/",$movie->poster);
					$poster = $movie->poster;
					$movies[] = new ShortMovie(
					intval($movie->id),
					strval($movie->title),
					strval($movie->pic));
					}
				}
			}
	}
       /* $movies = array();
        foreach ($data->groups->item as $movie)
        {
	    #$poster = str_ireplace("/vodCoversSmall/","/vodCoversBig/",$movie->poster);
	    $poster = $movie->poster;
            $movies[] = new ShortMovie(
                intval($movie->id),
                strval($movie->title),
                strval($movie->pic));
        }*/

        return new ShortMovieRange(0, count($movies), $movies);
    }
    public function get_archive(MediaURL $media_url)
    { 
        return $this->session->get_archive();
    }
}

///////////////////////////////////////////////////////////////////////////
?>
